unit RgReaderApiType;

interface

uses
  Winapi.Windows, RgReaderApiDef;

const
  MAX_STRING_LENGTH = 64;
  UID_LENGTH = 8;
  MIFARE_BLOCK_LENGTH = 16;

type
  // uint8_t	  	8 , ,  
  // uint16_t	   16 , ,  
  // uint32_t	   32 , ,  
  // int8_t		    8 , ,  
  // int16_t		 16 , ,  
  // int32_t		 32 , ,  

  uint32p = ^uint32;
  uint16p = ^uint16;
  uint8p = ^uint8;
  int32p = ^int32;

  Tapi_error = cardinal;

  TRG_CARD_UID = array [0 .. UID_LENGTH - 1] of uint8;
  TRG_MIFARE_KEY = array [0 .. 5] of uint8;
  TRG_MIFARE_AES_KEY = array [0 .. 15] of uint8;
  Tblock_data = array [0 .. 15] of uint8;
  TRG_STAGE = (STAGE_BOOT = 0, STAGE_WRITE, STAGE_COMPLETE,
    STAGE_COMPLETE_ERROR);
  TRespBuf = array [0 .. 255] of uint8;
    TRg_SetBlock=array [0 .. 31] of uint8;

  TCallBackFn = procedure(mode: TRG_STAGE; currentBlock: uint16;
    totalBlocks: uint16; error: Tapi_error); cdecl;
  PCallBackFn = ^TCallBackFn;

  /// <summary>
  ///       .  
  ///   .
  ///      /  .
  /// </summary>
  TRG_ENDPOINT_INFO = packed record
    /// <summary>
    ///   ,  TRG_CONNECTION_TYPE
    ///    .
    /// </summary>
    ENDPOINT_TYPE: TRG_ENDPOINT_TYPE;
    /// <summary>
    ///    (- ASCII )
    ///    - 64 ,   \0
    /// </summary>
    address: array [0 .. 64 - 1] of ansichar;
    /// <summary>
    ///  ()    (- ASCII )
    ///    - 128 ,   \0
    /// </summary>
    friendly_name: array [0 .. 128 - 1] of ansichar;
  end;

  /// <summary>
  ///      
  /// </summary>
  PRG_ENDPOINT_INFO = ^TRG_ENDPOINT_INFO;

  /// <summary>
  ///          /
  /// </summary>
  TPRG_ENDPOINT = packed record
    /// <summary>
    ///   ,  TRG_ENDPOINT_TYPE
    ///    .
    /// </summary>
    ENDPOINT_TYPE: TRG_ENDPOINT_TYPE;
    /// <summary>
    ///    (- ASCII )
    /// </summary>
    address: ansistring;
    // ----------------------           HID
  end;

  /// <summary>
  ///      
  /// </summary>
  PRG_ENDPOINT = ^TPRG_ENDPOINT;

  /// <summary>
  ///    ( 202)
  /// </summary>
  TRG_DEVICE_INFO_SHORT = packed record
    /// <summary>
    ///  
    /// </summary>
    address: uint8;
    /// <summary>
    ///  
    /// </summary>
    device_Type: TRG_DEVICE_TYPE;
    /// <summary>
    ///  
    /// </summary>
    firmware: uint8;
    /// <summary>
    ///   
    /// </summary>
    codogramms: uint8;
  end;

  /// <summary>
  ///       ( 202)
  /// </summary>
  PRG_DEVICE_INFO_SHORT = ^TRG_DEVICE_INFO_SHORT;

  /// <summary>
  ///   
  /// </summary>
  TRG_DEVICE_INFO_EXT = packed record
    /// <summary>
    ///  
    /// </summary>
    address: uint8;
    /// <summary>
    ///  
    /// </summary>
    serial: uint32;
    /// <summary>
    ///      
    /// </summary>
    // ---------------------  
    firmwareUpdateLock: uint8;
    /// <summary>
    ///  
    /// </summary>
    device_Type: TRG_DEVICE_TYPE;
    /// <summary>
    ///  
    /// </summary>
    firmware: uint16;
    /// <summary>
    ///   
    /// </summary>
    // ---------------------   
    capabilities: uint32;
  end;

  /// <summary>
  ///      
  /// </summary>
  PRG_DEVICE_INFO_EXT = ^TRG_DEVICE_INFO_EXT;

  /// <summary>
  ///   
  /// </summary>
  TRG_CARD_INFO = packed record
    /// <summary>
    ///  ,  TRG_CARD_TYPE_CODE
    /// </summary>
    cardType: TRG_CARD_TYPE_CODE;
    /// <summary>
    /// UID 
    /// </summary>
    cardUid: TRG_CARD_UID;
  end;

  /// <summary>
  ///      
  /// </summary>
  PRG_CARD_INFO = ^TRG_CARD_INFO;

  /// <summary>
  ///     
  /// </summary>
  TRG_CARD_MEMORY = packed record
    /// <summary>
    ///     ,     
    /// </summary>
    profile_block: uint8;
    /// <summary>
    ///  
    /// </summary
    block_data: Tblock_data;
  end;

  /// <summary>
  ///       
  /// </summary>
  PRG_CARD_MEMORY = ^TRG_CARD_MEMORY;

  /// <summary>
  ///     Mifare
  /// </summary>
  TRG_CARD_AUTH_PARAMS = packed record
    /// <summary>
    ///  ,  E_RG_CARD_AUTH_FLAGS
    /// </summary>
    asscessFlags: uint8;
    /// <summary>
    ///    Mifare Classic
    /// </summary>
    classicKey: TRG_MIFARE_KEY;
    /// <summary>
    ///    Mifare Plus SL3
    /// </summary>
    plusKey: TRG_MIFARE_AES_KEY;
  end;

  /// <summary>
  ///       Mifare
  /// </summary>
  PRG_CARD_AUTH_PARAMS = ^TRG_CARD_AUTH_PARAMS;

  /// <summary>
  ///  
  // -------------------------------  .    \
  /// </summary>
  TRG_GetVersion = function(): cardinal; cdecl;

  /// <summary>
  ///     .
  /// =0
  /// </summary>
  // TRG_InitializeLib = function(params: uint32): Tapi_error; cdecl;
  TRG_InitializeLib = function(): Tapi_error; cdecl;

  /// <summary>
  ///     .
  /// </summary>
  /// <returns></returns>
  TRG_Uninitialize = function(): Tapi_error; cdecl;

  /// <summary>
  ///         .
  /// </summary>
  /// <param name="handle"> .</param>
  /// <returns></returns>
  TRG_CloseResource = function(handle: THandle): Tapi_error; cdecl;

  /// <summary>
  ///     .
  /// </summary>
  /// <param name="pEndPointListHandle">  ,         .</param>
  /// -------------------------------------------   pCount  enpointTypeMask
  /// <param name="pCount">   .</param>
  /// <param name="pCount">  ,         .</param>
  /// <returns></returns>
  TRG_FindEndPoints = function(pEndPointListHandle: pHandle;
    enpointTypeMask: TRG_ENDPOINT_TYPE; pCount: uint32p): Tapi_error; cdecl;

  /// <summary>
  /// -------------------------------------------    RG_GetEndpointList
  ///    ,     RG_GetEndpointList,       .
  /// </summary>
  /// <param name="endPointListHandle">   ,   RG_GetEndpointList.</param>
  /// <param name="listIndex">  .</param>
  /// <param name="pEndpointInfo">      .</param>
  /// <returns></returns>
  TRG_GetFoundEndPointInfo = function(endPointListHandle: THandle;
    listIndex: uint32; pEndpointInfo: PRG_ENDPOINT_INFO): Tapi_error; cdecl;

  /// <summary>
  /// -------------------------------------------   ,  
  ///        .
  /// </summary>
  /// <param name="pDevicesListHandle">  ,        .</param>
  /// ---------------------   
  /// <param name="pCount">  ,         .</param>
  /// <returns></returns>
  TRG_FindDevices = function(pDevicesListHandle: pHandle;
    endpointTypeMask: uint8; pCount: uint32p): Tapi_error; cdecl;

  /// <summary>
  ///    ,     RG_GetDevicesList,     .
  ///  RDR-202
  /// </summary>
  /// <param name="deviceListHandle">   ,   RG_GetDevicesList.</param>
  /// <param name="listIndex">  .</param>
  /// <param name="pEndpointInfo">      .</param>
  /// <param name="pDeviceInfoExt">      .</param>
  /// <returns></returns>
  TRG_GetFoundDeviceInfo = function(deviceListHandle: THandle;
    listIndex: uint32; pEndpointInfo: PRG_ENDPOINT_INFO;
    pDeviceInfoExt: PRG_DEVICE_INFO_EXT): Tapi_error; cdecl;

  /// <summary>
  ///  .
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <returns></returns>
  TRG_InitDevice = function(pEndPoint: PRG_ENDPOINT; address: uint8)
    : Tapi_error; cdecl;

  /// <summary>
  ///   .   .
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <returns></returns>
  TRG_CloseDevice = function(pEndPoint: PRG_ENDPOINT; address: uint8)
    : Tapi_error; cdecl;

  /// <summary>
  ///    .      RG_InitDevice.
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pDeviceInfo">     .</param>
  /// <returns></returns>
  TRG_GetInfo = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pDeviceInfo: PRG_DEVICE_INFO_SHORT): Tapi_error; cdecl;

  /// <summary>
  /// -------------------------------------------        ?
  ///     .
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pDeviceInfo">      .</param>
  /// <returns></returns>
  TRG_GetInfoExt = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pDeviceInfo: PRG_DEVICE_INFO_EXT): Tapi_error; cdecl;

  /// <summary>
  ///      .      RG_InitDevice.
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="mCardsFamilyMask">   ,  TRG_CARD_FAMILY_CODE.</param>
  /// <returns></returns>
  TRG_SetCardsMask = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    mCardsFamilyMask: uint8): Tapi_error; cdecl;

  /// <summary>
  ///      .      RG_InitDevice.
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <returns></returns>
  TRG_ClearProfiles = function(pEndPoint: PRG_ENDPOINT; address: uint8)
    : Tapi_error; cdecl;

  /// <summary>
  ///     .      RG_InitDevice.
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="mProfileNum"> ,        .</param>
  /// <param name="mBlockNum">  .</param>
  /// <param name="pCardAuthParams">     .</param>
  /// <returns></returns>
  TRG_WriteProfile = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    profileNum: uint8; blockNum: uint8; pCardAuthParams: PRG_CARD_AUTH_PARAMS)
    : Tapi_error; cdecl;

  /// <summary>
  /// -------------------------------------------        - Pin?  FF      - .
  ///           .
  ///      RG_InitDevice.
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pStatusType">  ,       .</param>
  /// <param name="pPinStates">  ,        /.</param>
  /// <param name="pCardInfo">     ,      .</param>
  /// <param name="pMemory">   ,          .     pMemory->profile_block.</param>
  /// <returns> </returns>
  TRG_GetStatus = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pStatusType: PRG_STATUS_TYPE; pPinStates: uint8p; pCardInfo: PRG_CARD_INFO;
    pMemory: PRG_CARD_MEMORY): Tapi_error; cdecl;

  // NLMK
  // TRG_SetProfile = function(pEndPoint: PRG_ENDPOINT; address: uint8)
  // : Tapi_error; cdecl;

  /// <summary>
  ///    ,          (,    SL1  SL3)   
  ///      RG_InitDevice.
  ///      ,   RG_IsolateDevice().
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="mAddress">  (0...3,     ).</param>
  /// <returns></returns>
  TRG_ResetField = function(pEndPoint: PRG_ENDPOINT; address: uint8)
    : Tapi_error; cdecl;

  /// <summary>
  ///      ,     .
  ///      RG_InitDevice.
  ///      ,   RG_IsolateDevice().
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="mAddress">  (0...3,     ).</param>
  /// <param name="pSak">      SAK (Select Acknowledge)</param>
  /// <param name="pAtq">        Mifare.</param>
  /// <param name="pUidBuf">      UID  .</param>
  /// <param name="pAtq">     pUidBufSize.</param>
  /// <returns></returns>
  TRG_Iso_Ras = function(pEndPoint: PRG_ENDPOINT; address: uint8; pSak: uint16p;
    pAtqa: uint16p; pUidBuf: pointer; uidBufSize: int32): Tapi_error; cdecl;

  /// <summary>
  ///     Mifare Classic
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="mAddress">  (0...3,     ).</param>
  /// <param name="blockNum">  ,    .</param>
  /// <param name="keyType">    (A/B).</param>
  /// <param name="pKeyBuf">   , ,  , 6    .</param>
  /// <returns></returns>
  TRG_MF_AuthorizeClassic = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    blockNum: uint8; keyType: uint8; pKeyBuf: uint8p): Tapi_error; cdecl;

  /// <summary>
  ///    Mifare.
  ///      RG_InitDevice.
  ///      ,   RG_IsolateDevice().
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="mAddress">  (0...3,     ).</param>
  /// <param name="blockNum">  ,    .</param>
  /// <param name="pKeyBuf">       .</param>
  /// <param name="keyBufSize">  /   pKeyBuf (    - 16 ).</param>
  /// <returns></returns>
  TRG_Iso_Auth = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    blockNum: uint16; pKeyBuf: uint8p; keyBufSize: int32): Tapi_error; cdecl;

  /// <summary>
  ///        Mifare Classic/Plus
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="mAddress">  (0...3,     ).</param>
  /// <param name="flags">   ,    .</param>
  /// <param name="blockNum">  .</param>
  /// <param name="pDataBuf">   ,          .</param>
  /// <param name="dataBufSize">     pDataBuf.</param>
  /// <returns></returns>
  TRG_MF_ReadBlock = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    blockNum: uint8; flags: uint8; pDataBuf: uint8p; dataBufSize: int32)
    : Tapi_error; cdecl;

  /// <summary>
  ///        Mifare Classic/Plus
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="mAddress">  (0...3,     ).</param>
  /// <param name="flags">   ,      (Classic/Plus).</param>
  /// <param name="blockNum">  .</param>
  /// <param name="pDataBuf">     ,       .</param>
  /// <param name="dataBufSize">     pDataBuf.</param>
  /// <returns></returns>
  TRG_MF_WriteBlock = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    blockNum: uint8; flags: uint8; pDataBuf: uint8p; dataBufSize: int32)
    : Tapi_error; cdecl;

  /// <summary>
  ///       ISO 14443-4
  ///      RG_InitDevice.
  ///      ,   RG_IsolateDevice().
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pAtsBuf">      UID  .</param>
  /// <param name="atsBufSize">     pAtsBuf</param>
  /// <param name="pAtsSize">  ,    ,   pAtsBuf.</param>
  /// <returns></returns>
  TRG_Iso_Rats = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pAtsBuf: uint8p; atsBufSize: int32; pAtsSize: int32p): Tapi_error; cdecl;

  /// <summary>
  ///       ISO14443-4.
  ///      RG_InitDevice.
  ///      ,   RG_IsolateDevice().
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pReqBuf">   ,     .</param>
  /// <param name="reqBufSize">     pDataBuf.</param>
  /// <param name="pRespBuf">   ,        .</param>
  /// <param name="respBufSize">     respBufSize.</param>
  /// <param name="pRespSize">  ,    ,   pRespBuf.</param>
  /// <returns></returns>
  TRG_Iso_Exchange = function(pEndPoint: PRG_ENDPOINT; address: uint8;
    const pReqBuf: uint8p; reqBufSize: int32; pRespBuf: uint8p;
    respBufSize: int32; pRespSize: int32p): Tapi_error; cdecl;

  TRG_UpdateFirmware = Function(pEndPoint: PRG_ENDPOINT; address: uint8;
    const fwFilePath: ansistring; CallBackFn: PCallBackFn): Tapi_error; cdecl;


  /// <summary>
  ///           .
  ///      RG_InitDevice.
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pStatusType">  ,       .</param>
  /// <param name="pUidBuffer">   ,   UID.</param>
  /// <param name="uidBufferSize">     pUidBuffer.</param>
  /// <param name="pUidSize">  ,      UID .</param>
  /// <returns> </returns>
  TRG_GetCard = Function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pStatusType: PRG_STATUS_TYPE; pUidBuffer: uint8p; uidBufferSize: int32;
    pUidSize: int32p): Tapi_error; cdecl;

  /// <summary>
  ///   PIN-  
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pin">PIN-</param>
  /// <returns></returns>
  TRG_UnlockSettigns = Function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pin: uint16): Tapi_error; cdecl;

  /// <summary>
  ///   PIN-  
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="pin">PIN-</param>
  /// <returns></returns>
  TRG_CommitSettings = Function(pEndPoint: PRG_ENDPOINT; address: uint8;
    pin: uint16): Tapi_error; cdecl;

  /// <summary>
  ///    
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="blockType">  ,  E_RG_SETTINGS_BLOCK_TYPE</param>
  /// <param name="blockNum"> /</param>
  /// <param name="block32Buf">   ,         </param>
  /// <param name="block32BufSize">     pBlockData</param>
  /// <returns></returns>
  TRG_ReadSettingsBlock = Function(pEndPoint: PRG_ENDPOINT; address: uint8;
    blockType: TRG_SETTINGS_BLOCK_TYPE; blockNum: uint16; block32Buf: uint8p;
    block32BufSize: int32): Tapi_error; cdecl;

  /// <summary>
  ///    
  /// </summary>
  /// <param name="pEndPoint">    .</param>
  /// <param name="address">  (0...3,     ).</param>
  /// <param name="blockType">  ,  E_RG_SETTINGS_BLOCK_TYPE</param>
  /// <param name="blockNum"> /</param>
  /// <param name="block32Buf">       ,   ,   32 .</param>
  /// <param name="block32BufSize">     pBlockData</param>
  /// <returns></returns>
  TRG_WriteSettingsBlock = Function(pEndPoint: PRG_ENDPOINT; address: uint8;
    blockType: TRG_SETTINGS_BLOCK_TYPE; blockNum: uint16; const block32Buf: uint8p;
    block32BufSize: int32): Tapi_error; cdecl;

implementation

end.
